% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_package_plots.R
\name{plot_y_vs_yhat}
\alias{plot_y_vs_yhat}
\title{Plot the fitted Versus Actual Response}
\usage{
plot_y_vs_yhat(
  bart_machine,
  Xtest = NULL,
  ytest = NULL,
  credible_intervals = FALSE,
  prediction_intervals = FALSE,
  interval_confidence_level = 0.95,
  verbose = TRUE
)
}
\arguments{
\item{bart_machine}{An object of class ``bartMachine''.}

\item{Xtest}{Optional argument for test data. If included, BART computes fitted values at the rows of \code{Xtest}. Else, the fitted values from the training data are used.}

\item{ytest}{Optional argument for test data. Vector of observed values corresponding to the rows of \code{Xtest} to be plotted against the predictions for the rows of \code{Xtest}.}

\item{credible_intervals}{If TRUE, Bayesian credible intervals are computed using the quantiles of the posterior distribution of \eqn{\hat{f}(x)}. See \code{\link{calc_credible_intervals}} for details.}

\item{prediction_intervals}{If TRUE, Bayesian predictive intervals are computed using the a draw of from \eqn{\hat{f}(x)}. See \code{\link{calc_prediction_intervals}} for details.}

\item{interval_confidence_level}{Desired level of confidence for credible or prediction intervals.}

\item{verbose}{If TRUE, prints plots to the active device.}
}
\value{
None.
}
\description{
Generates a plot actual versus fitted values and corresponding credible intervals or prediction intervals for the fitted values.
}
\note{
This function is parallelized by the number of cores set in \code{\link{set_bart_machine_num_cores}}.
}
\examples{
\dontrun{
#generate linear data
set.seed(11)
n  = 500
p = 3
X = data.frame(matrix(runif(n * p), ncol = p))
y = 3*X[ ,1] + 2*X[ ,2] +X[ ,3] + rnorm(n)

##build BART regression model
bart_machine = bartMachine(X, y)

##generate plot
plot_y_vs_yhat(bart_machine)

#generate plot with prediction bands
plot_y_vs_yhat(bart_machine, prediction_intervals = TRUE)
}
}
\seealso{
\code{\link{bart_machine_get_posterior}}, \code{\link{calc_credible_intervals}}, \code{\link{calc_prediction_intervals}}
}
\author{
Adam Kapelner and Justin Bleich
}
