% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numeric_mechanism.R
\docType{class}
\name{DPMechNumeric-class}
\alias{DPMechNumeric-class}
\alias{DPMechNumeric}
\alias{show,DPMechNumeric-method}
\alias{sensitivityNorm,DPMechNumeric-method}
\alias{releaseResponse,DPMechNumeric,DPParamsEps-method}
\title{A virtual S4 class for differentially-private numeric mechanisms.}
\usage{
\S4method{show}{DPMechNumeric}(object)

\S4method{sensitivityNorm}{DPMechNumeric}(mechanism, X1, X2)

\S4method{releaseResponse}{DPMechNumeric,DPParamsEps}(mechanism, privacyParams,
  X)
}
\arguments{
\item{object}{an instance of class \code{DPMech}.}

\item{mechanism}{an object of class \code{DPMechNumeric-class}.}

\item{X1}{a privacy-sensitive dataset.}

\item{X2}{a privacy-sensitive dataset.}

\item{privacyParams}{an object of class \code{\link{DPParamsEps}}.}

\item{X}{a privacy-sensitive dataset, if using sensitivity sampler a: list,
matrix, data frame, numeric/character vector.}
}
\value{
scalar numeric norm of non-private \code{target} on datasets.

list with slots per argument, actual privacy parameter;
  mechanism response with length of target release:
  \code{privacyParams, sensitivity, dims, target, response}.
}
\description{
A virtual class that implements common features of Laplace, Gaussian
mechanisms from differential privacy, for privatizing numeric vector
releases.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: automatically prints the object.

\item \code{sensitivityNorm}: measures sensitivity of non-private \code{target}.

\item \code{releaseResponse}: releases mechanism responses.
}}

\section{Slots}{

\describe{
\item{\code{sensitivity}}{non-negative scalar numeric target sensitivity.
Defaults to \code{Inf} for use with \code{sensitivitySampler()}.}

\item{\code{target}}{the target non-private function to be privatized, takes lists.
Defaults to a constant function. Laplace mechanism assumes functions that
release numeric vectors of fixed dimension \code{dims}.}

\item{\code{gammaSensitivity}}{\code{NA_real_} if deactive, or scalar in [0,1)
indicating that responses must be RDP with specific confidence.}

\item{\code{dims}}{positive scalar numeric dimension of responses. Defaults to
\code{NA_integer_} for use with \code{sensitivitySampler()} which can
probe \code{target} to determine dimension.}
}}

\examples{
f <- function(xs) mean(xs)
n <- 100
m <- DPMechLaplace(sensitivity = 1/n, target = f, dims = 1)
X1 <- runif(n)
X2 <- runif(n)
sensitivityNorm(m, X1, X2)
f <- function(xs) mean(xs)
n <- 100
m <- DPMechLaplace(sensitivity = 1/n, target = f, dims = 1)
X <- runif(n)
p <- DPParamsEps(epsilon = 1)
releaseResponse(m, p, X)
}
