% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernstein_polynomials.R
\name{bernstein}
\alias{bernstein}
\title{Fit a Bernstein polynomial approximation.}
\usage{
bernstein(f, dims, k = 10)
}
\arguments{
\item{f}{a function to be approximated.}

\item{dims}{the function \code{f}'s domain dimension.}

\item{k}{the lattice resolution of approximation.}
}
\value{
an S3 object of class \code{bernstein}.
}
\description{
Fits the basis of Bernstein polynomial functions to given real-valued
function \code{f} of \eqn{[0,1]^d} where \eqn{d=}\code{dims}, against
a regular lattice of \eqn{k+1} points in each dimension for given
\code{k}. Note the approximation is not the iterated variant.
}
\examples{
f <- function(x) x * sin(x*10)
b <- bernstein(f, dims = 1)
xs <- seq(from=0, to=1, length=50)
mean((f(xs) - predict(b,xs))^2)

}
\references{
Francesco Aldà and Benjamin I. P. Rubinstein. "The Bernstein Mechanism:
  Function Release under Differential Privacy", in Proceedings of the 31st
  AAAI Conference on Artificial Intelligence (AAAI'2017), pp. 1705-1711,
  Feb 2017.
}
\seealso{
\code{\link{predict.bernstein}} for subsequent evaluation.
}
