% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgInfo.R
\name{print.pcache}
\alias{print.pcache}
\title{Print a Package Cache Object}
\usage{
\method{print}{pcache}(x, ...)
}
\arguments{
\item{x}{The package cache to print.}

\item{...}{Follow-on parameters to the print function.}
}
\value{
The package cache object, invisibly.
}
\description{
Print routine for a package cache object of class "pcache".
}
\examples{
# Create vector of packages
pkgs <- c("ggplot2", "patchwork", "gt")

# Capture cache versions
res <- pkg_cache(pkgs)

# Print cache versions
print(res)
# # A package cache object
# - Last Update: 2025-03-01 20:51 UTC
# - Packages:
#     Package Version
# 1   ggplot2   3.5.1
# 2 patchwork   1.3.0
# 3        gt  0.11.1
}
\seealso{
Other pdiff: 
\code{\link{pkg_cache}()},
\code{\link{pkg_diff}()},
\code{\link{pkg_info}()},
\code{\link{pkg_stability}()},
\code{\link{pkg_versions}()},
\code{\link{print.pdiff}()},
\code{\link{print.pdiff_score}()},
\code{\link{print.pinfo}()}
}
\concept{pdiff}
